package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler7PleaseUpdateCloneValue extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	int worldId;
	
	@Value(id = 2)
	int typeId;
	
	public Handler7PleaseUpdateCloneValue(){
		
	}
	
	public Handler7PleaseUpdateCloneValue(EntityClone clone, int typeId){
		this.entityId = clone.entityId;
		this.worldId = clone.worldObj.provider.dimensionId;
		this.typeId = typeId;
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, worldId);
			if(clone != null && clone.canUseThisEntity(player.username)){
				clone.sendValueToClient(player, typeId);
			}
		}
	}
	
	

}
